---
title: Tags · Cloudflare Style Guide
description: Tags are currently used to filter content in the ExternalResources
  and the ResourcesBySelector components.
lastUpdated: 2025-08-12T17:54:27.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/frontmatter/tags/
  md: https://developers.cloudflare.com/style-guide/frontmatter/tags/index.md
---

Tags are currently used to filter content in the [`ExternalResources`](https://developers.cloudflare.com/style-guide/components/external-resources/) and the [`ResourcesBySelector`](https://developers.cloudflare.com/style-guide/components/resources-by-selector/) components.

## Example

```mdx
---
title: Example
tags:
  - foo
  - bar
---
```

## Allowed tags and where they are being used

Tags are validated against an allowlist in [`/src/schemas/tags.ts`](https://github.com/cloudflare/cloudflare-docs/blob/production/src/schemas/tags.ts) which defines the user-facing representation (`label`) and any associated variants.

The matching is case-insensitive. For example, all of the following values are accepted in the `tags` frontmatter array and will be transformed into `Node.js`:

* `node.js`
* `NoDe.JS`
* `node`
* `nodejs`

### .NET

Used on `2` pages.

Pages tagged with .NET

* [pulumi/tutorial/add-site](https://developers.cloudflare.com/pulumi/tutorial/add-site/)
* [pulumi/tutorial/hello-world](https://developers.cloudflare.com/pulumi/tutorial/hello-world/)

### A/B testing

Variants:

* `ab test`

Used on `2` pages.

Pages tagged with A/B testing

* [rules/snippets/examples/ab-testing-same-url](https://developers.cloudflare.com/rules/snippets/examples/ab-testing-same-url/)
* [rules/snippets/examples/append-dates-to-cookies](https://developers.cloudflare.com/rules/snippets/examples/append-dates-to-cookies/)

### AI

Used on `49` pages.

Pages tagged with AI

* [agents](https://developers.cloudflare.com/agents/)
* [ai-crawl-control](https://developers.cloudflare.com/ai-crawl-control/)
* [ai-gateway](https://developers.cloudflare.com/ai-gateway/)
* [ai-search](https://developers.cloudflare.com/ai-search/)
* [vectorize](https://developers.cloudflare.com/vectorize/)
* [workers-ai](https://developers.cloudflare.com/workers-ai/)
* [agents/api-reference/using-ai-models](https://developers.cloudflare.com/agents/api-reference/using-ai-models/)
* [agents/concepts/what-are-agents](https://developers.cloudflare.com/agents/concepts/what-are-agents/)
* [ai-crawl-control/features/analyze-ai-traffic](https://developers.cloudflare.com/ai-crawl-control/features/analyze-ai-traffic/)
* [ai-gateway/tutorials/deploy-aig-worker](https://developers.cloudflare.com/ai-gateway/tutorials/deploy-aig-worker/)
* [ai-gateway/usage/chat-completion](https://developers.cloudflare.com/ai-gateway/usage/chat-completion/)
* [ai-search/how-to/bring-your-own-generation-model](https://developers.cloudflare.com/ai-search/how-to/bring-your-own-generation-model/)
* [bots/additional-configurations/ai-labyrinth](https://developers.cloudflare.com/bots/additional-configurations/ai-labyrinth/)
* [bots/additional-configurations/block-ai-bots](https://developers.cloudflare.com/bots/additional-configurations/block-ai-bots/)
* [browser-rendering/how-to/ai](https://developers.cloudflare.com/browser-rendering/how-to/ai/)
* [cloudflare-one/tutorials/ai-wrapper-tenant-control](https://developers.cloudflare.com/cloudflare-one/tutorials/ai-wrapper-tenant-control/)
* [workers/get-started/prompting](https://developers.cloudflare.com/workers/get-started/prompting/)
* [workers/examples/openai-sdk-streaming](https://developers.cloudflare.com/workers/examples/openai-sdk-streaming/)
* [workers/tutorials/create-finetuned-chatgpt-ai-models-with-r2](https://developers.cloudflare.com/workers/tutorials/create-finetuned-chatgpt-ai-models-with-r2/)
* [workers/tutorials/openai-function-calls-workers](https://developers.cloudflare.com/workers/tutorials/openai-function-calls-workers/)
* [workers-ai/features/prompting](https://developers.cloudflare.com/workers-ai/features/prompting/)
* [ai-gateway/features/guardrails](https://developers.cloudflare.com/ai-gateway/features/guardrails/)
* [ai-gateway/usage/providers/workersai](https://developers.cloudflare.com/ai-gateway/usage/providers/workersai/)
* [reference-architecture/diagrams/ai/ai-asset-creation](https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-asset-creation/)
* [reference-architecture/diagrams/ai/ai-composable](https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-composable/)
* [reference-architecture/diagrams/ai/ai-multivendor-observability-control](https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-multivendor-observability-control/)
* [reference-architecture/diagrams/ai/ai-rag](https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-rag/)
* [reference-architecture/diagrams/ai/ai-video-caption](https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-video-caption/)
* [reference-architecture/diagrams/ai/bigquery-workers-ai](https://developers.cloudflare.com/reference-architecture/diagrams/ai/bigquery-workers-ai/)
* [waf/detections/firewall-for-ai/example-rules](https://developers.cloudflare.com/waf/detections/firewall-for-ai/example-rules/)
* [waf/detections/firewall-for-ai/fields](https://developers.cloudflare.com/waf/detections/firewall-for-ai/fields/)
* [waf/detections/firewall-for-ai/get-started](https://developers.cloudflare.com/waf/detections/firewall-for-ai/get-started/)
* [waf/detections/firewall-for-ai](https://developers.cloudflare.com/waf/detections/firewall-for-ai/)
* [workers-ai/guides/tutorials/build-a-retrieval-augmented-generation-ai](https://developers.cloudflare.com/workers-ai/guides/tutorials/build-a-retrieval-augmented-generation-ai/)
* [workers-ai/guides/tutorials/build-a-workers-ai-whisper-with-chunking](https://developers.cloudflare.com/workers-ai/guides/tutorials/build-a-workers-ai-whisper-with-chunking/)
* [workers-ai/guides/tutorials/explore-code-generation-using-deepseek-coder-models](https://developers.cloudflare.com/workers-ai/guides/tutorials/explore-code-generation-using-deepseek-coder-models/)
* [workers-ai/guides/tutorials/explore-workers-ai-models-using-a-jupyter-notebook](https://developers.cloudflare.com/workers-ai/guides/tutorials/explore-workers-ai-models-using-a-jupyter-notebook/)
* [workers-ai/guides/tutorials/fine-tune-models-with-autotrain](https://developers.cloudflare.com/workers-ai/guides/tutorials/fine-tune-models-with-autotrain/)
* [workers-ai/guides/tutorials/how-to-choose-the-right-text-generation-model](https://developers.cloudflare.com/workers-ai/guides/tutorials/how-to-choose-the-right-text-generation-model/)
* [workers-ai/guides/tutorials](https://developers.cloudflare.com/workers-ai/guides/tutorials/)
* [workers-ai/guides/tutorials/llama-vision-tutorial](https://developers.cloudflare.com/workers-ai/guides/tutorials/llama-vision-tutorial/)
* [workers-ai/guides/tutorials/using-bigquery-with-workers-ai](https://developers.cloudflare.com/workers-ai/guides/tutorials/using-bigquery-with-workers-ai/)
* [workers-ai/guides/tutorials/image-generation-playground/image-generator-flux-newmodels](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-flux-newmodels/)
* [workers-ai/guides/tutorials/image-generation-playground/image-generator-flux](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-flux/)
* [workers-ai/guides/tutorials/image-generation-playground/image-generator-store-and-catalog](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-store-and-catalog/)
* [workers-ai/guides/tutorials/image-generation-playground](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/)
* [workers-ai/features/function-calling/embedded/examples/fetch](https://developers.cloudflare.com/workers-ai/features/function-calling/embedded/examples/fetch/)
* [workers-ai/features/function-calling/embedded/examples/kv](https://developers.cloudflare.com/workers-ai/features/function-calling/embedded/examples/kv/)
* [workers-ai/features/function-calling/embedded/examples/openapi](https://developers.cloudflare.com/workers-ai/features/function-calling/embedded/examples/openapi/)

### Angular

Used on `1` pages.

Pages tagged with Angular

* [workers/framework-guides/web-apps/more-web-frameworks/angular](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/angular/)

### Astro

Used on `1` pages.

Pages tagged with Astro

* [workers/framework-guides/web-apps/astro](https://developers.cloudflare.com/workers/framework-guides/web-apps/astro/)

### Authentication

Variants:

* `auth`

Used on `5` pages.

Pages tagged with Authentication

* [workers/examples/auth-with-headers](https://developers.cloudflare.com/workers/examples/auth-with-headers/)
* [workers/examples/basic-auth](https://developers.cloudflare.com/workers/examples/basic-auth/)
* [rules/snippets/examples/auth-with-headers](https://developers.cloudflare.com/rules/snippets/examples/auth-with-headers/)
* [rules/snippets/examples/jwt-validation](https://developers.cloudflare.com/rules/snippets/examples/jwt-validation/)
* [rules/snippets/examples/signing-requests](https://developers.cloudflare.com/rules/snippets/examples/signing-requests/)

### Bindings

Variants:

* `binding`

Used on `11` pages.

Pages tagged with Bindings

* [ai-gateway/integrations/worker-binding-methods](https://developers.cloudflare.com/ai-gateway/integrations/worker-binding-methods/)
* [ai-search/usage/workers-binding](https://developers.cloudflare.com/ai-search/usage/workers-binding/)
* [byoip/service-bindings](https://developers.cloudflare.com/byoip/service-bindings/)
* [browser-rendering/workers-bindings](https://developers.cloudflare.com/browser-rendering/workers-bindings/)
* [kv/concepts/kv-bindings](https://developers.cloudflare.com/kv/concepts/kv-bindings/)
* [pages/functions/bindings](https://developers.cloudflare.com/pages/functions/bindings/)
* [workers/static-assets/binding](https://developers.cloudflare.com/workers/static-assets/binding/)
* [workflows/build/trigger-workflows](https://developers.cloudflare.com/workflows/build/trigger-workflows/)
* [cloudflare-for-platforms/workers-for-platforms/get-started/bindings](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/get-started/bindings/)
* [workers/runtime-apis/bindings](https://developers.cloudflare.com/workers/runtime-apis/bindings/)
* [workers/runtime-apis/bindings/service-bindings](https://developers.cloudflare.com/workers/runtime-apis/bindings/service-bindings/)

### Caching

Variants:

* `cache`

Used on `5` pages.

Pages tagged with Caching

* [workers/examples/cache-api](https://developers.cloudflare.com/workers/examples/cache-api/)
* [workers/examples/cache-post-request](https://developers.cloudflare.com/workers/examples/cache-post-request/)
* [workers/examples/cache-tags](https://developers.cloudflare.com/workers/examples/cache-tags/)
* [workers/examples/cache-using-fetch](https://developers.cloudflare.com/workers/examples/cache-using-fetch/)
* [rules/snippets/examples/custom-cache](https://developers.cloudflare.com/rules/snippets/examples/custom-cache/)

### Cookies

Used on `3` pages.

Pages tagged with Cookies

* [rules/snippets/examples/ab-testing-same-url](https://developers.cloudflare.com/rules/snippets/examples/ab-testing-same-url/)
* [rules/snippets/examples/append-dates-to-cookies](https://developers.cloudflare.com/rules/snippets/examples/append-dates-to-cookies/)
* [rules/snippets/examples/override-set-cookies-value](https://developers.cloudflare.com/rules/snippets/examples/override-set-cookies-value/)

### Debugging

Variants:

* `debug`
* `troubleshooting`

Used on `2` pages.

Pages tagged with Debugging

* [workers/examples/debugging-logs](https://developers.cloudflare.com/workers/examples/debugging-logs/)
* [workers/examples/logging-headers](https://developers.cloudflare.com/workers/examples/logging-headers/)

### Forms

Used on `4` pages.

Pages tagged with Forms

* [pages/tutorials/add-a-react-form-with-formspree](https://developers.cloudflare.com/pages/tutorials/add-a-react-form-with-formspree/)
* [pages/tutorials/add-an-html-form-with-formspree](https://developers.cloudflare.com/pages/tutorials/add-an-html-form-with-formspree/)
* [pages/tutorials/forms](https://developers.cloudflare.com/pages/tutorials/forms/)
* [workers/tutorials/handle-form-submissions-with-airtable](https://developers.cloudflare.com/workers/tutorials/handle-form-submissions-with-airtable/)

### Geolocation

Used on `6` pages.

Pages tagged with Geolocation

* [network/ip-geolocation](https://developers.cloudflare.com/network/ip-geolocation/)
* [workers/examples/country-code-redirect](https://developers.cloudflare.com/workers/examples/country-code-redirect/)
* [workers/examples/geolocation-app-weather](https://developers.cloudflare.com/workers/examples/geolocation-app-weather/)
* [workers/examples/geolocation-custom-styling](https://developers.cloudflare.com/workers/examples/geolocation-custom-styling/)
* [workers/examples/geolocation-hello-world](https://developers.cloudflare.com/workers/examples/geolocation-hello-world/)
* [cloudflare-one/traffic-policies/network-policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/)

### Go

Used on `2` pages.

Pages tagged with Go

* [pulumi/tutorial/add-site](https://developers.cloudflare.com/pulumi/tutorial/add-site/)
* [pulumi/tutorial/hello-world](https://developers.cloudflare.com/pulumi/tutorial/hello-world/)

### GraphQL

Used on `3` pages.

Pages tagged with GraphQL

* [cloudflare-one/tutorials/graphql-analytics](https://developers.cloudflare.com/cloudflare-one/tutorials/graphql-analytics/)
* [magic-firewall/tutorials/graphql-analytics](https://developers.cloudflare.com/magic-firewall/tutorials/graphql-analytics/)
* [magic-network-monitoring/tutorials/graphql-analytics](https://developers.cloudflare.com/magic-network-monitoring/tutorials/graphql-analytics/)

### Headers

Variants:

* `header`

Used on `15` pages.

Pages tagged with Headers

* [workers/examples/103-early-hints](https://developers.cloudflare.com/workers/examples/103-early-hints/)
* [workers/examples/alter-headers](https://developers.cloudflare.com/workers/examples/alter-headers/)
* [workers/examples/cors-header-proxy](https://developers.cloudflare.com/workers/examples/cors-header-proxy/)
* [workers/examples/extract-cookie-value](https://developers.cloudflare.com/workers/examples/extract-cookie-value/)
* [workers/examples/hot-link-protection](https://developers.cloudflare.com/workers/examples/hot-link-protection/)
* [workers/examples/logging-headers](https://developers.cloudflare.com/workers/examples/logging-headers/)
* [workers/examples/modify-request-property](https://developers.cloudflare.com/workers/examples/modify-request-property/)
* [workers/examples/modify-response](https://developers.cloudflare.com/workers/examples/modify-response/)
* [pages/functions/examples/cors-headers](https://developers.cloudflare.com/pages/functions/examples/cors-headers/)
* [rules/snippets/examples/bot-data-to-origin](https://developers.cloudflare.com/rules/snippets/examples/bot-data-to-origin/)
* [rules/snippets/examples/define-cors-headers](https://developers.cloudflare.com/rules/snippets/examples/define-cors-headers/)
* [rules/snippets/examples/hex-timestamp](https://developers.cloudflare.com/rules/snippets/examples/hex-timestamp/)
* [rules/snippets/examples/override-set-cookies-value](https://developers.cloudflare.com/rules/snippets/examples/override-set-cookies-value/)
* [rules/snippets/examples/security-headers](https://developers.cloudflare.com/rules/snippets/examples/security-headers/)
* [rules/snippets/examples/send-timestamp-to-origin](https://developers.cloudflare.com/rules/snippets/examples/send-timestamp-to-origin/)

### Hono

Used on `11` pages.

Pages tagged with Hono

* [d1/examples/d1-and-hono](https://developers.cloudflare.com/d1/examples/d1-and-hono/)
* [d1/tutorials/build-a-comments-api](https://developers.cloudflare.com/d1/tutorials/build-a-comments-api/)
* [d1/tutorials/build-a-staff-directory-app](https://developers.cloudflare.com/d1/tutorials/build-a-staff-directory-app/)
* [d1/tutorials/build-an-api-to-access-d1](https://developers.cloudflare.com/d1/tutorials/build-an-api-to-access-d1/)
* [pages/framework-guides/deploy-a-hono-site](https://developers.cloudflare.com/pages/framework-guides/deploy-a-hono-site/)
* [pages/tutorials/use-r2-as-static-asset-storage-for-pages](https://developers.cloudflare.com/pages/tutorials/use-r2-as-static-asset-storage-for-pages/)
* [workers/tutorials/build-a-slackbot](https://developers.cloudflare.com/workers/tutorials/build-a-slackbot/)
* [workers/tutorials/create-finetuned-chatgpt-ai-models-with-r2](https://developers.cloudflare.com/workers/tutorials/create-finetuned-chatgpt-ai-models-with-r2/)
* [learning-paths/workers/get-started/first-application](https://developers.cloudflare.com/learning-paths/workers/get-started/first-application/)
* [workers-ai/guides/tutorials/build-a-retrieval-augmented-generation-ai](https://developers.cloudflare.com/workers-ai/guides/tutorials/build-a-retrieval-augmented-generation-ai/)
* [workers/framework-guides/web-apps/more-web-frameworks/hono](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/hono/)

### IPv6

Used on `6` pages.

Pages tagged with IPv6

* [network/ipv6-compatibility](https://developers.cloudflare.com/network/ipv6-compatibility/)
* [1.1.1.1/infrastructure/ipv6-networks](https://developers.cloudflare.com/1.1.1.1/infrastructure/ipv6-networks/)
* [aegis/about/ips-allocation](https://developers.cloudflare.com/aegis/about/ips-allocation/)
* [magic-transit/how-to/ipv6](https://developers.cloudflare.com/magic-transit/how-to/ipv6/)
* [reference-architecture/design-guides/securing-guest-wireless-networks](https://developers.cloudflare.com/reference-architecture/design-guides/securing-guest-wireless-networks/)
* [cloudflare-one/team-and-resources/devices/agentless/dns/locations](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/)

### JSON

Used on `11` pages.

Pages tagged with JSON

* [browser-rendering/rest-api/json-endpoint](https://developers.cloudflare.com/browser-rendering/rest-api/json-endpoint/)
* [d1/sql-api/query-json](https://developers.cloudflare.com/d1/sql-api/query-json/)
* [ruleset-engine/rulesets-api/json-object](https://developers.cloudflare.com/ruleset-engine/rulesets-api/json-object/)
* [waiting-room/how-to/json-response](https://developers.cloudflare.com/waiting-room/how-to/json-response/)
* [workers/examples/fetch-json](https://developers.cloudflare.com/workers/examples/fetch-json/)
* [workers/examples/post-json](https://developers.cloudflare.com/workers/examples/post-json/)
* [workers/examples/read-post](https://developers.cloudflare.com/workers/examples/read-post/)
* [workers/examples/return-json](https://developers.cloudflare.com/workers/examples/return-json/)
* [workers-ai/features/json-mode](https://developers.cloudflare.com/workers-ai/features/json-mode/)
* [ddos-protection/advanced-ddos-systems/api/dns-protection/json-objects](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/api/dns-protection/json-objects/)
* [waf/tools/lists/lists-api/json-object](https://developers.cloudflare.com/waf/tools/lists/lists-api/json-object/)

### Java

Used on `2` pages.

Pages tagged with Java

* [pulumi/tutorial/add-site](https://developers.cloudflare.com/pulumi/tutorial/add-site/)
* [pulumi/tutorial/hello-world](https://developers.cloudflare.com/pulumi/tutorial/hello-world/)

### JavaScript

Variants:

* `js`

Used on `73` pages.

Pages tagged with JavaScript

* [ai-gateway/tutorials/deploy-aig-worker](https://developers.cloudflare.com/ai-gateway/tutorials/deploy-aig-worker/)
* [browser-rendering/workers-bindings/browser-rendering-with-do](https://developers.cloudflare.com/browser-rendering/workers-bindings/browser-rendering-with-do/)
* [cloudflare-one/tutorials/access-workers](https://developers.cloudflare.com/cloudflare-one/tutorials/access-workers/)
* [d1/tutorials/build-a-comments-api](https://developers.cloudflare.com/d1/tutorials/build-a-comments-api/)
* [d1/tutorials/import-to-d1-with-rest-api](https://developers.cloudflare.com/d1/tutorials/import-to-d1-with-rest-api/)
* [d1/tutorials/using-read-replication-for-e-com](https://developers.cloudflare.com/d1/tutorials/using-read-replication-for-e-com/)
* [pages/migrations/migrating-from-netlify](https://developers.cloudflare.com/pages/migrations/migrating-from-netlify/)
* [pages/tutorials/add-a-react-form-with-formspree](https://developers.cloudflare.com/pages/tutorials/add-a-react-form-with-formspree/)
* [pages/tutorials/build-a-blog-using-nuxt-and-sanity](https://developers.cloudflare.com/pages/tutorials/build-a-blog-using-nuxt-and-sanity/)
* [pages/tutorials/build-an-api-with-pages-functions](https://developers.cloudflare.com/pages/tutorials/build-an-api-with-pages-functions/)
* [pages/tutorials/forms](https://developers.cloudflare.com/pages/tutorials/forms/)
* [pages/tutorials/localize-a-website](https://developers.cloudflare.com/pages/tutorials/localize-a-website/)
* [pages/tutorials/use-r2-as-static-asset-storage-for-pages](https://developers.cloudflare.com/pages/tutorials/use-r2-as-static-asset-storage-for-pages/)
* [pulumi/tutorial/add-site](https://developers.cloudflare.com/pulumi/tutorial/add-site/)
* [pulumi/tutorial/hello-world](https://developers.cloudflare.com/pulumi/tutorial/hello-world/)
* [turnstile/tutorials/implicit-vs-explicit-rendering](https://developers.cloudflare.com/turnstile/tutorials/implicit-vs-explicit-rendering/)
* [turnstile/tutorials/integrating-turnstile-waf-and-bot-management](https://developers.cloudflare.com/turnstile/tutorials/integrating-turnstile-waf-and-bot-management/)
* [turnstile/tutorials/login-pages](https://developers.cloudflare.com/turnstile/tutorials/login-pages/)
* [workers/examples/103-early-hints](https://developers.cloudflare.com/workers/examples/103-early-hints/)
* [workers/examples/ab-testing](https://developers.cloudflare.com/workers/examples/ab-testing/)
* [workers/examples/accessing-the-cloudflare-object](https://developers.cloudflare.com/workers/examples/accessing-the-cloudflare-object/)
* [workers/examples/aggregate-requests](https://developers.cloudflare.com/workers/examples/aggregate-requests/)
* [workers/examples/alter-headers](https://developers.cloudflare.com/workers/examples/alter-headers/)
* [workers/examples/auth-with-headers](https://developers.cloudflare.com/workers/examples/auth-with-headers/)
* [workers/examples/block-on-tls](https://developers.cloudflare.com/workers/examples/block-on-tls/)
* [workers/examples/basic-auth](https://developers.cloudflare.com/workers/examples/basic-auth/)
* [workers/examples/bulk-origin-proxy](https://developers.cloudflare.com/workers/examples/bulk-origin-proxy/)
* [workers/examples/bulk-redirects](https://developers.cloudflare.com/workers/examples/bulk-redirects/)
* [workers/examples/cache-api](https://developers.cloudflare.com/workers/examples/cache-api/)
* [workers/examples/cache-post-request](https://developers.cloudflare.com/workers/examples/cache-post-request/)
* [workers/examples/cache-tags](https://developers.cloudflare.com/workers/examples/cache-tags/)
* [workers/examples/cache-using-fetch](https://developers.cloudflare.com/workers/examples/cache-using-fetch/)
* [workers/examples/cors-header-proxy](https://developers.cloudflare.com/workers/examples/cors-header-proxy/)
* [workers/examples/conditional-response](https://developers.cloudflare.com/workers/examples/conditional-response/)
* [workers/examples/cron-trigger](https://developers.cloudflare.com/workers/examples/cron-trigger/)
* [workers/examples/country-code-redirect](https://developers.cloudflare.com/workers/examples/country-code-redirect/)
* [workers/examples/data-loss-prevention](https://developers.cloudflare.com/workers/examples/data-loss-prevention/)
* [workers/examples/debugging-logs](https://developers.cloudflare.com/workers/examples/debugging-logs/)
* [workers/examples/extract-cookie-value](https://developers.cloudflare.com/workers/examples/extract-cookie-value/)
* [workers/examples/fetch-json](https://developers.cloudflare.com/workers/examples/fetch-json/)
* [workers/examples/fetch-html](https://developers.cloudflare.com/workers/examples/fetch-html/)
* [workers/examples/geolocation-app-weather](https://developers.cloudflare.com/workers/examples/geolocation-app-weather/)
* [workers/examples/geolocation-custom-styling](https://developers.cloudflare.com/workers/examples/geolocation-custom-styling/)
* [workers/examples/geolocation-hello-world](https://developers.cloudflare.com/workers/examples/geolocation-hello-world/)
* [workers/examples/hot-link-protection](https://developers.cloudflare.com/workers/examples/hot-link-protection/)
* [workers/examples/images-workers](https://developers.cloudflare.com/workers/examples/images-workers/)
* [workers/examples/logging-headers](https://developers.cloudflare.com/workers/examples/logging-headers/)
* [workers/examples/modify-request-property](https://developers.cloudflare.com/workers/examples/modify-request-property/)
* [workers/examples/modify-response](https://developers.cloudflare.com/workers/examples/modify-response/)
* [workers/examples/multiple-cron-triggers](https://developers.cloudflare.com/workers/examples/multiple-cron-triggers/)
* [workers/examples/openai-sdk-streaming](https://developers.cloudflare.com/workers/examples/openai-sdk-streaming/)
* [workers/examples/post-json](https://developers.cloudflare.com/workers/examples/post-json/)
* [workers/examples/redirect](https://developers.cloudflare.com/workers/examples/redirect/)
* [workers/examples/respond-with-another-site](https://developers.cloudflare.com/workers/examples/respond-with-another-site/)
* [workers/examples/read-post](https://developers.cloudflare.com/workers/examples/read-post/)
* [workers/examples/return-html](https://developers.cloudflare.com/workers/examples/return-html/)
* [workers/examples/return-json](https://developers.cloudflare.com/workers/examples/return-json/)
* [workers/examples/rewrite-links](https://developers.cloudflare.com/workers/examples/rewrite-links/)
* [workers/examples/security-headers](https://developers.cloudflare.com/workers/examples/security-headers/)
* [workers/examples/signing-requests](https://developers.cloudflare.com/workers/examples/signing-requests/)
* [workers/examples/turnstile-html-rewriter](https://developers.cloudflare.com/workers/examples/turnstile-html-rewriter/)
* [workers/examples/websockets](https://developers.cloudflare.com/workers/examples/websockets/)
* [workers/tutorials/build-a-jamstack-app](https://developers.cloudflare.com/workers/tutorials/build-a-jamstack-app/)
* [workers/tutorials/build-a-qr-code-generator](https://developers.cloudflare.com/workers/tutorials/build-a-qr-code-generator/)
* [workers/tutorials/deploy-a-realtime-chat-app](https://developers.cloudflare.com/workers/tutorials/deploy-a-realtime-chat-app/)
* [workers/tutorials/generate-youtube-thumbnails-with-workers-and-images](https://developers.cloudflare.com/workers/tutorials/generate-youtube-thumbnails-with-workers-and-images/)
* [workers/tutorials/github-sms-notifications-using-twilio](https://developers.cloudflare.com/workers/tutorials/github-sms-notifications-using-twilio/)
* [workers/tutorials/handle-form-submissions-with-airtable](https://developers.cloudflare.com/workers/tutorials/handle-form-submissions-with-airtable/)
* [workers/tutorials/openai-function-calls-workers](https://developers.cloudflare.com/workers/tutorials/openai-function-calls-workers/)
* [workers/tutorials/send-emails-with-postmark](https://developers.cloudflare.com/workers/tutorials/send-emails-with-postmark/)
* [workers/tutorials/send-emails-with-resend](https://developers.cloudflare.com/workers/tutorials/send-emails-with-resend/)
* [workers-ai/guides/tutorials/build-a-retrieval-augmented-generation-ai](https://developers.cloudflare.com/workers-ai/guides/tutorials/build-a-retrieval-augmented-generation-ai/)
* [workers-ai/guides/tutorials/using-bigquery-with-workers-ai](https://developers.cloudflare.com/workers-ai/guides/tutorials/using-bigquery-with-workers-ai/)

### LLM

Variants:

* `llms`

Used on `8` pages.

Pages tagged with LLM

* [agents/concepts/calling-llms](https://developers.cloudflare.com/agents/concepts/calling-llms/)
* [agents/concepts/what-are-agents](https://developers.cloudflare.com/agents/concepts/what-are-agents/)
* [ai-search/concepts/what-is-rag](https://developers.cloudflare.com/ai-search/concepts/what-is-rag/)
* [browser-rendering/how-to/ai](https://developers.cloudflare.com/browser-rendering/how-to/ai/)
* [vectorize/reference/what-is-a-vector-database](https://developers.cloudflare.com/vectorize/reference/what-is-a-vector-database/)
* [workers/get-started/prompting](https://developers.cloudflare.com/workers/get-started/prompting/)
* [workers-ai/features/function-calling](https://developers.cloudflare.com/workers-ai/features/function-calling/)
* [workers-ai/guides/tutorials/fine-tune-models-with-autotrain](https://developers.cloudflare.com/workers-ai/guides/tutorials/fine-tune-models-with-autotrain/)

### Localization

Used on `1` pages.

Pages tagged with Localization

* [rules/snippets/examples/country-code-redirect](https://developers.cloudflare.com/rules/snippets/examples/country-code-redirect/)

### Logging

Used on `2` pages.

Pages tagged with Logging

* [rules/snippets/examples/debugging-logs](https://developers.cloudflare.com/rules/snippets/examples/debugging-logs/)
* [rules/snippets/examples/return-incoming-request-properties](https://developers.cloudflare.com/rules/snippets/examples/return-incoming-request-properties/)

### MCP

Used on `15` pages.

Pages tagged with MCP

* [agents/guides/connect-mcp-client](https://developers.cloudflare.com/agents/guides/connect-mcp-client/)
* [agents/guides/oauth-mcp-client](https://developers.cloudflare.com/agents/guides/oauth-mcp-client/)
* [agents/guides/remote-mcp-server](https://developers.cloudflare.com/agents/guides/remote-mcp-server/)
* [agents/guides/test-remote-mcp-server](https://developers.cloudflare.com/agents/guides/test-remote-mcp-server/)
* [agents/model-context-protocol](https://developers.cloudflare.com/agents/model-context-protocol/)
* [agents/model-context-protocol/authorization](https://developers.cloudflare.com/agents/model-context-protocol/authorization/)
* [agents/model-context-protocol/mcp-agent-api](https://developers.cloudflare.com/agents/model-context-protocol/mcp-agent-api/)
* [agents/model-context-protocol/mcp-client-api](https://developers.cloudflare.com/agents/model-context-protocol/mcp-client-api/)
* [agents/model-context-protocol/mcp-portal](https://developers.cloudflare.com/agents/model-context-protocol/mcp-portal/)
* [agents/model-context-protocol/mcp-servers-for-cloudflare](https://developers.cloudflare.com/agents/model-context-protocol/mcp-servers-for-cloudflare/)
* [agents/model-context-protocol/transport](https://developers.cloudflare.com/agents/model-context-protocol/transport/)
* [browser-rendering/playwright/playwright-mcp](https://developers.cloudflare.com/browser-rendering/playwright/playwright-mcp/)
* [cloudflare-one/access-controls/ai-controls/linked-apps](https://developers.cloudflare.com/cloudflare-one/access-controls/ai-controls/linked-apps/)
* [cloudflare-one/access-controls/ai-controls/mcp-portals](https://developers.cloudflare.com/cloudflare-one/access-controls/ai-controls/mcp-portals/)
* [cloudflare-one/access-controls/ai-controls/saas-mcp](https://developers.cloudflare.com/cloudflare-one/access-controls/ai-controls/saas-mcp/)

### Middleware

Used on `16` pages.

Pages tagged with Middleware

* [workers/examples/103-early-hints](https://developers.cloudflare.com/workers/examples/103-early-hints/)
* [workers/examples/alter-headers](https://developers.cloudflare.com/workers/examples/alter-headers/)
* [workers/examples/block-on-tls](https://developers.cloudflare.com/workers/examples/block-on-tls/)
* [workers/examples/bulk-origin-proxy](https://developers.cloudflare.com/workers/examples/bulk-origin-proxy/)
* [workers/examples/bulk-redirects](https://developers.cloudflare.com/workers/examples/bulk-redirects/)
* [workers/examples/cache-api](https://developers.cloudflare.com/workers/examples/cache-api/)
* [workers/examples/cache-post-request](https://developers.cloudflare.com/workers/examples/cache-post-request/)
* [workers/examples/cache-using-fetch](https://developers.cloudflare.com/workers/examples/cache-using-fetch/)
* [workers/examples/conditional-response](https://developers.cloudflare.com/workers/examples/conditional-response/)
* [workers/examples/cron-trigger](https://developers.cloudflare.com/workers/examples/cron-trigger/)
* [workers/examples/modify-request-property](https://developers.cloudflare.com/workers/examples/modify-request-property/)
* [workers/examples/modify-response](https://developers.cloudflare.com/workers/examples/modify-response/)
* [workers/examples/multiple-cron-triggers](https://developers.cloudflare.com/workers/examples/multiple-cron-triggers/)
* [workers/examples/redirect](https://developers.cloudflare.com/workers/examples/redirect/)
* [workers/examples/respond-with-another-site](https://developers.cloudflare.com/workers/examples/respond-with-another-site/)
* [workers/examples/security-headers](https://developers.cloudflare.com/workers/examples/security-headers/)

### MySQL

Used on `1` pages.

Pages tagged with MySQL

* [workers/tutorials/mysql](https://developers.cloudflare.com/workers/tutorials/mysql/)

### Node.js

Variants:

* `node`
* `nodejs`

Used on `4` pages.

Pages tagged with Node.js

* [turnstile/tutorials/conditionally-enforcing-turnstile](https://developers.cloudflare.com/turnstile/tutorials/conditionally-enforcing-turnstile/)
* [turnstile/tutorials/excluding-turnstile-from-e2e-tests](https://developers.cloudflare.com/turnstile/tutorials/excluding-turnstile-from-e2e-tests/)
* [turnstile/tutorials/implicit-vs-explicit-rendering](https://developers.cloudflare.com/turnstile/tutorials/implicit-vs-explicit-rendering/)
* [turnstile/tutorials/login-pages](https://developers.cloudflare.com/turnstile/tutorials/login-pages/)

### Nuxt

Used on `2` pages.

Pages tagged with Nuxt

* [pages/tutorials/build-a-blog-using-nuxt-and-sanity](https://developers.cloudflare.com/pages/tutorials/build-a-blog-using-nuxt-and-sanity/)
* [workers/framework-guides/web-apps/more-web-frameworks/nuxt](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/nuxt/)

### Playback

Used on `10` pages.

Pages tagged with Playback

* [stream/examples/android](https://developers.cloudflare.com/stream/examples/android/)
* [stream/examples/dash-js](https://developers.cloudflare.com/stream/examples/dash-js/)
* [stream/examples/hls-js](https://developers.cloudflare.com/stream/examples/hls-js/)
* [stream/examples/ios](https://developers.cloudflare.com/stream/examples/ios/)
* [stream/examples/rtmps\_playback](https://developers.cloudflare.com/stream/examples/rtmps_playback/)
* [stream/examples/shaka-player](https://developers.cloudflare.com/stream/examples/shaka-player/)
* [stream/examples/srt\_playback](https://developers.cloudflare.com/stream/examples/srt_playback/)
* [stream/examples/video-js](https://developers.cloudflare.com/stream/examples/video-js/)
* [stream/examples/stream-player](https://developers.cloudflare.com/stream/examples/stream-player/)
* [stream/examples/vidstack](https://developers.cloudflare.com/stream/examples/vidstack/)

### Postgres

Variants:

* `PostgreSQL`

Used on `3` pages.

Pages tagged with Postgres

* [hyperdrive/tutorials/serverless-timeseries-api-with-timescale](https://developers.cloudflare.com/hyperdrive/tutorials/serverless-timeseries-api-with-timescale/)
* [workers/tutorials/postgres](https://developers.cloudflare.com/workers/tutorials/postgres/)
* [workers/tutorials/using-prisma-postgres-with-workers](https://developers.cloudflare.com/workers/tutorials/using-prisma-postgres-with-workers/)

### Prisma ORM

Used on `1` pages.

Pages tagged with Prisma ORM

* [workers/tutorials/using-prisma-postgres-with-workers](https://developers.cloudflare.com/workers/tutorials/using-prisma-postgres-with-workers/)

### Privacy

Used on `5` pages.

Pages tagged with Privacy

* [warp-client/privacy](https://developers.cloudflare.com/warp-client/privacy/)
* [web-analytics/about](https://developers.cloudflare.com/web-analytics/about/)
* [speed/observatory/rum-beacon](https://developers.cloudflare.com/speed/observatory/rum-beacon/)
* [waf/tools/privacy-pass](https://developers.cloudflare.com/waf/tools/privacy-pass/)
* [zaraz/consent-management](https://developers.cloudflare.com/zaraz/consent-management/)

### Python

Variants:

* `py`

Used on `46` pages.

Pages tagged with Python

* [cloudflare-one/tutorials/fastapi](https://developers.cloudflare.com/cloudflare-one/tutorials/fastapi/)
* [d1/examples/query-d1-from-python-workers](https://developers.cloudflare.com/d1/examples/query-d1-from-python-workers/)
* [pulumi/tutorial/add-site](https://developers.cloudflare.com/pulumi/tutorial/add-site/)
* [pulumi/tutorial/hello-world](https://developers.cloudflare.com/pulumi/tutorial/hello-world/)
* [workers/examples/103-early-hints](https://developers.cloudflare.com/workers/examples/103-early-hints/)
* [workers/examples/ab-testing](https://developers.cloudflare.com/workers/examples/ab-testing/)
* [workers/examples/accessing-the-cloudflare-object](https://developers.cloudflare.com/workers/examples/accessing-the-cloudflare-object/)
* [workers/examples/aggregate-requests](https://developers.cloudflare.com/workers/examples/aggregate-requests/)
* [workers/examples/alter-headers](https://developers.cloudflare.com/workers/examples/alter-headers/)
* [workers/examples/auth-with-headers](https://developers.cloudflare.com/workers/examples/auth-with-headers/)
* [workers/examples/block-on-tls](https://developers.cloudflare.com/workers/examples/block-on-tls/)
* [workers/examples/bulk-origin-proxy](https://developers.cloudflare.com/workers/examples/bulk-origin-proxy/)
* [workers/examples/bulk-redirects](https://developers.cloudflare.com/workers/examples/bulk-redirects/)
* [workers/examples/cache-api](https://developers.cloudflare.com/workers/examples/cache-api/)
* [workers/examples/cache-post-request](https://developers.cloudflare.com/workers/examples/cache-post-request/)
* [workers/examples/cache-tags](https://developers.cloudflare.com/workers/examples/cache-tags/)
* [workers/examples/cache-using-fetch](https://developers.cloudflare.com/workers/examples/cache-using-fetch/)
* [workers/examples/cors-header-proxy](https://developers.cloudflare.com/workers/examples/cors-header-proxy/)
* [workers/examples/conditional-response](https://developers.cloudflare.com/workers/examples/conditional-response/)
* [workers/examples/country-code-redirect](https://developers.cloudflare.com/workers/examples/country-code-redirect/)
* [workers/examples/data-loss-prevention](https://developers.cloudflare.com/workers/examples/data-loss-prevention/)
* [workers/examples/debugging-logs](https://developers.cloudflare.com/workers/examples/debugging-logs/)
* [workers/examples/extract-cookie-value](https://developers.cloudflare.com/workers/examples/extract-cookie-value/)
* [workers/examples/fetch-json](https://developers.cloudflare.com/workers/examples/fetch-json/)
* [workers/examples/fetch-html](https://developers.cloudflare.com/workers/examples/fetch-html/)
* [workers/examples/geolocation-app-weather](https://developers.cloudflare.com/workers/examples/geolocation-app-weather/)
* [workers/examples/geolocation-hello-world](https://developers.cloudflare.com/workers/examples/geolocation-hello-world/)
* [workers/examples/hot-link-protection](https://developers.cloudflare.com/workers/examples/hot-link-protection/)
* [workers/examples/images-workers](https://developers.cloudflare.com/workers/examples/images-workers/)
* [workers/examples/logging-headers](https://developers.cloudflare.com/workers/examples/logging-headers/)
* [workers/examples/modify-request-property](https://developers.cloudflare.com/workers/examples/modify-request-property/)
* [workers/examples/modify-response](https://developers.cloudflare.com/workers/examples/modify-response/)
* [workers/examples/protect-against-timing-attacks](https://developers.cloudflare.com/workers/examples/protect-against-timing-attacks/)
* [workers/examples/post-json](https://developers.cloudflare.com/workers/examples/post-json/)
* [workers/examples/redirect](https://developers.cloudflare.com/workers/examples/redirect/)
* [workers/examples/respond-with-another-site](https://developers.cloudflare.com/workers/examples/respond-with-another-site/)
* [workers/examples/read-post](https://developers.cloudflare.com/workers/examples/read-post/)
* [workers/examples/return-html](https://developers.cloudflare.com/workers/examples/return-html/)
* [workers/examples/return-json](https://developers.cloudflare.com/workers/examples/return-json/)
* [workers/examples/rewrite-links](https://developers.cloudflare.com/workers/examples/rewrite-links/)
* [workers/examples/security-headers](https://developers.cloudflare.com/workers/examples/security-headers/)
* [workers/examples/signing-requests](https://developers.cloudflare.com/workers/examples/signing-requests/)
* [workers/examples/turnstile-html-rewriter](https://developers.cloudflare.com/workers/examples/turnstile-html-rewriter/)
* [workers-ai/guides/tutorials/explore-code-generation-using-deepseek-coder-models](https://developers.cloudflare.com/workers-ai/guides/tutorials/explore-code-generation-using-deepseek-coder-models/)
* [workers-ai/guides/tutorials/explore-workers-ai-models-using-a-jupyter-notebook](https://developers.cloudflare.com/workers-ai/guides/tutorials/explore-workers-ai-models-using-a-jupyter-notebook/)
* [workers-ai/guides/tutorials/how-to-choose-the-right-text-generation-model](https://developers.cloudflare.com/workers-ai/guides/tutorials/how-to-choose-the-right-text-generation-model/)

### RPC

Used on `3` pages.

Pages tagged with RPC

* [durable-objects/best-practices/create-durable-object-stubs-and-send-requests](https://developers.cloudflare.com/durable-objects/best-practices/create-durable-object-stubs-and-send-requests/)
* [workers/runtime-apis/rpc](https://developers.cloudflare.com/workers/runtime-apis/rpc/)
* [workers/runtime-apis/bindings/service-bindings/rpc](https://developers.cloudflare.com/workers/runtime-apis/bindings/service-bindings/rpc/)

### Redirects

Variants:

* `redirect`

Used on `11` pages.

Pages tagged with Redirects

* [workers/examples/bulk-redirects](https://developers.cloudflare.com/workers/examples/bulk-redirects/)
* [workers/examples/country-code-redirect](https://developers.cloudflare.com/workers/examples/country-code-redirect/)
* [workers/examples/redirect](https://developers.cloudflare.com/workers/examples/redirect/)
* [rules/snippets/examples/bots-to-honeypot](https://developers.cloudflare.com/rules/snippets/examples/bots-to-honeypot/)
* [rules/snippets/examples/bulk-redirect-map](https://developers.cloudflare.com/rules/snippets/examples/bulk-redirect-map/)
* [rules/snippets/examples/country-code-redirect](https://developers.cloudflare.com/rules/snippets/examples/country-code-redirect/)
* [rules/snippets/examples/follow-redirects](https://developers.cloudflare.com/rules/snippets/examples/follow-redirects/)
* [rules/snippets/examples/maintenance](https://developers.cloudflare.com/rules/snippets/examples/maintenance/)
* [rules/snippets/examples/redirect-forbidden-status](https://developers.cloudflare.com/rules/snippets/examples/redirect-forbidden-status/)
* [rules/snippets/examples/redirect-replaced-domain](https://developers.cloudflare.com/rules/snippets/examples/redirect-replaced-domain/)
* [rules/snippets/examples/serve-different-origin](https://developers.cloudflare.com/rules/snippets/examples/serve-different-origin/)

### Remix

Used on `2` pages.

Pages tagged with Remix

* [d1/examples/d1-and-remix](https://developers.cloudflare.com/d1/examples/d1-and-remix/)
* [pages/framework-guides/deploy-a-remix-site](https://developers.cloudflare.com/pages/framework-guides/deploy-a-remix-site/)

### Request modification

Variants:

* `request`

Used on `13` pages.

Pages tagged with Request modification

* [rules/snippets/examples/auth-with-headers](https://developers.cloudflare.com/rules/snippets/examples/auth-with-headers/)
* [rules/snippets/examples/bot-data-to-origin](https://developers.cloudflare.com/rules/snippets/examples/bot-data-to-origin/)
* [rules/snippets/examples/define-cors-headers](https://developers.cloudflare.com/rules/snippets/examples/define-cors-headers/)
* [rules/snippets/examples/hex-timestamp](https://developers.cloudflare.com/rules/snippets/examples/hex-timestamp/)
* [rules/snippets/examples/jwt-validation](https://developers.cloudflare.com/rules/snippets/examples/jwt-validation/)
* [rules/snippets/examples/remove-query-strings](https://developers.cloudflare.com/rules/snippets/examples/remove-query-strings/)
* [rules/snippets/examples/send-timestamp-to-origin](https://developers.cloudflare.com/rules/snippets/examples/send-timestamp-to-origin/)
* [rules/snippets/examples/signing-requests](https://developers.cloudflare.com/rules/snippets/examples/signing-requests/)
* [rules/snippets/examples/slow-suspicious-requests](https://developers.cloudflare.com/rules/snippets/examples/slow-suspicious-requests/)
* [rules/transform/examples/add-request-header-bot-score](https://developers.cloudflare.com/rules/transform/examples/add-request-header-bot-score/)
* [rules/transform/examples/add-request-header-static-value](https://developers.cloudflare.com/rules/transform/examples/add-request-header-static-value/)
* [rules/transform/examples/add-request-header-subrequest-other-zone](https://developers.cloudflare.com/rules/transform/examples/add-request-header-subrequest-other-zone/)
* [rules/transform/examples/remove-request-header](https://developers.cloudflare.com/rules/transform/examples/remove-request-header/)

### Response modification

Variants:

* `response`

Used on `12` pages.

Pages tagged with Response modification

* [rules/snippets/examples/debugging-logs](https://developers.cloudflare.com/rules/snippets/examples/debugging-logs/)
* [rules/snippets/examples/define-cors-headers](https://developers.cloudflare.com/rules/snippets/examples/define-cors-headers/)
* [rules/snippets/examples/override-set-cookies-value](https://developers.cloudflare.com/rules/snippets/examples/override-set-cookies-value/)
* [rules/snippets/examples/remove-fields-api-response](https://developers.cloudflare.com/rules/snippets/examples/remove-fields-api-response/)
* [rules/snippets/examples/remove-response-headers](https://developers.cloudflare.com/rules/snippets/examples/remove-response-headers/)
* [rules/snippets/examples/return-incoming-request-properties](https://developers.cloudflare.com/rules/snippets/examples/return-incoming-request-properties/)
* [rules/snippets/examples/rewrite-site-links](https://developers.cloudflare.com/rules/snippets/examples/rewrite-site-links/)
* [rules/snippets/examples/security-headers](https://developers.cloudflare.com/rules/snippets/examples/security-headers/)
* [rules/transform/examples/add-response-header-static-value](https://developers.cloudflare.com/rules/transform/examples/add-response-header-static-value/)
* [rules/transform/examples/remove-response-header](https://developers.cloudflare.com/rules/transform/examples/remove-response-header/)
* [rules/transform/examples/set-response-header-bot-score](https://developers.cloudflare.com/rules/transform/examples/set-response-header-bot-score/)
* [rules/transform/examples/set-response-header-static-value](https://developers.cloudflare.com/rules/transform/examples/set-response-header-static-value/)

### Ruby

Variants:

* `rb`
* `ruby on rails`

Used on `1` pages.

Pages tagged with Ruby

* [pages/migrations/migrating-jekyll-from-github-pages](https://developers.cloudflare.com/pages/migrations/migrating-jekyll-from-github-pages/)

### Rust

Variants:

* `rs`

Used on `12` pages.

Pages tagged with Rust

* [workers/examples/basic-auth](https://developers.cloudflare.com/workers/examples/basic-auth/)
* [workers/examples/cache-using-fetch](https://developers.cloudflare.com/workers/examples/cache-using-fetch/)
* [workers/examples/cors-header-proxy](https://developers.cloudflare.com/workers/examples/cors-header-proxy/)
* [workers/examples/logging-headers](https://developers.cloudflare.com/workers/examples/logging-headers/)
* [workers/examples/redirect](https://developers.cloudflare.com/workers/examples/redirect/)
* [workers/examples/read-post](https://developers.cloudflare.com/workers/examples/read-post/)
* [workers/examples/return-html](https://developers.cloudflare.com/workers/examples/return-html/)
* [workers/examples/return-json](https://developers.cloudflare.com/workers/examples/return-json/)
* [workers/examples/security-headers](https://developers.cloudflare.com/workers/examples/security-headers/)
* [workers/examples/websockets](https://developers.cloudflare.com/workers/examples/websockets/)
* [workers/tutorials/generate-youtube-thumbnails-with-workers-and-images](https://developers.cloudflare.com/workers/tutorials/generate-youtube-thumbnails-with-workers-and-images/)
* [workers/tutorials/workers-kv-from-rust](https://developers.cloudflare.com/workers/tutorials/workers-kv-from-rust/)

### S3

Used on `1` pages.

Pages tagged with S3

* [cloudflare-one/tutorials/s3-buckets](https://developers.cloudflare.com/cloudflare-one/tutorials/s3-buckets/)

### SQL

Used on `15` pages.

Pages tagged with SQL

* [r2-sql/sql-reference](https://developers.cloudflare.com/r2-sql/sql-reference/)
* [r2-sql/troubleshooting](https://developers.cloudflare.com/r2-sql/troubleshooting/)
* [d1/tutorials/build-a-comments-api](https://developers.cloudflare.com/d1/tutorials/build-a-comments-api/)
* [d1/tutorials/build-a-staff-directory-app](https://developers.cloudflare.com/d1/tutorials/build-a-staff-directory-app/)
* [d1/tutorials/build-an-api-to-access-d1](https://developers.cloudflare.com/d1/tutorials/build-an-api-to-access-d1/)
* [d1/tutorials/d1-and-prisma-orm](https://developers.cloudflare.com/d1/tutorials/d1-and-prisma-orm/)
* [d1/tutorials/import-to-d1-with-rest-api](https://developers.cloudflare.com/d1/tutorials/import-to-d1-with-rest-api/)
* [d1/tutorials/using-read-replication-for-e-com](https://developers.cloudflare.com/d1/tutorials/using-read-replication-for-e-com/)
* [durable-objects/tutorials/build-a-seat-booking-app](https://developers.cloudflare.com/durable-objects/tutorials/build-a-seat-booking-app/)
* [hyperdrive/tutorials/serverless-timeseries-api-with-timescale](https://developers.cloudflare.com/hyperdrive/tutorials/serverless-timeseries-api-with-timescale/)
* [r2-sql/reference/limitations-best-practices](https://developers.cloudflare.com/r2-sql/reference/limitations-best-practices/)
* [workers/tutorials/connect-to-turso-using-workers](https://developers.cloudflare.com/workers/tutorials/connect-to-turso-using-workers/)
* [workers/tutorials/mysql](https://developers.cloudflare.com/workers/tutorials/mysql/)
* [workers/tutorials/postgres](https://developers.cloudflare.com/workers/tutorials/postgres/)
* [workers/tutorials/using-prisma-postgres-with-workers](https://developers.cloudflare.com/workers/tutorials/using-prisma-postgres-with-workers/)

### SSO

Used on `5` pages.

Pages tagged with SSO

* [cloudflare-one/tutorials/extend-sso-with-workers](https://developers.cloudflare.com/cloudflare-one/tutorials/extend-sso-with-workers/)
* [fundamentals/manage-members/dashboard-sso](https://developers.cloudflare.com/fundamentals/manage-members/dashboard-sso/)
* [cloudflare-one/integrations/identity-providers](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/)
* [learning-paths/clientless-access/migrate-applications/integrated-sso](https://developers.cloudflare.com/learning-paths/clientless-access/migrate-applications/integrated-sso/)
* [learning-paths/secure-internet-traffic/secure-saas-applications/sso-front-door](https://developers.cloudflare.com/learning-paths/secure-internet-traffic/secure-saas-applications/sso-front-door/)

### Security

Used on `8` pages.

Pages tagged with Security

* [workers/examples/block-on-tls](https://developers.cloudflare.com/workers/examples/block-on-tls/)
* [workers/examples/basic-auth](https://developers.cloudflare.com/workers/examples/basic-auth/)
* [workers/examples/cors-header-proxy](https://developers.cloudflare.com/workers/examples/cors-header-proxy/)
* [workers/examples/data-loss-prevention](https://developers.cloudflare.com/workers/examples/data-loss-prevention/)
* [workers/examples/hot-link-protection](https://developers.cloudflare.com/workers/examples/hot-link-protection/)
* [workers/examples/protect-against-timing-attacks](https://developers.cloudflare.com/workers/examples/protect-against-timing-attacks/)
* [workers/examples/security-headers](https://developers.cloudflare.com/workers/examples/security-headers/)
* [workers/examples/signing-requests](https://developers.cloudflare.com/workers/examples/signing-requests/)

### Stripe

Used on `2` pages.

Pages tagged with Stripe

* [ai-crawl-control/features/pay-per-crawl/use-pay-per-crawl-as-ai-owner/connect-to-stripe](https://developers.cloudflare.com/ai-crawl-control/features/pay-per-crawl/use-pay-per-crawl-as-ai-owner/connect-to-stripe/)
* [ai-crawl-control/features/pay-per-crawl/use-pay-per-crawl-as-site-owner/manage-payouts](https://developers.cloudflare.com/ai-crawl-control/features/pay-per-crawl/use-pay-per-crawl-as-site-owner/manage-payouts/)

### Svelte

Used on `1` pages.

Pages tagged with Svelte

* [d1/examples/d1-and-sveltekit](https://developers.cloudflare.com/d1/examples/d1-and-sveltekit/)

### SvelteKit

Used on `1` pages.

Pages tagged with SvelteKit

* [d1/examples/d1-and-sveltekit](https://developers.cloudflare.com/d1/examples/d1-and-sveltekit/)

### TypeScript

Variants:

* `ts`

Used on `73` pages.

Pages tagged with TypeScript

* [d1/tutorials/build-a-staff-directory-app](https://developers.cloudflare.com/d1/tutorials/build-a-staff-directory-app/)
* [d1/tutorials/build-an-api-to-access-d1](https://developers.cloudflare.com/d1/tutorials/build-an-api-to-access-d1/)
* [d1/tutorials/d1-and-prisma-orm](https://developers.cloudflare.com/d1/tutorials/d1-and-prisma-orm/)
* [d1/tutorials/import-to-d1-with-rest-api](https://developers.cloudflare.com/d1/tutorials/import-to-d1-with-rest-api/)
* [d1/tutorials/using-read-replication-for-e-com](https://developers.cloudflare.com/d1/tutorials/using-read-replication-for-e-com/)
* [durable-objects/tutorials/build-a-seat-booking-app](https://developers.cloudflare.com/durable-objects/tutorials/build-a-seat-booking-app/)
* [hyperdrive/tutorials/serverless-timeseries-api-with-timescale](https://developers.cloudflare.com/hyperdrive/tutorials/serverless-timeseries-api-with-timescale/)
* [pulumi/tutorial/add-site](https://developers.cloudflare.com/pulumi/tutorial/add-site/)
* [pulumi/tutorial/hello-world](https://developers.cloudflare.com/pulumi/tutorial/hello-world/)
* [r2/tutorials/summarize-pdf](https://developers.cloudflare.com/r2/tutorials/summarize-pdf/)
* [r2/tutorials/upload-logs-event-notifications](https://developers.cloudflare.com/r2/tutorials/upload-logs-event-notifications/)
* [turnstile/tutorials/conditionally-enforcing-turnstile](https://developers.cloudflare.com/turnstile/tutorials/conditionally-enforcing-turnstile/)
* [turnstile/tutorials/excluding-turnstile-from-e2e-tests](https://developers.cloudflare.com/turnstile/tutorials/excluding-turnstile-from-e2e-tests/)
* [workers/examples/103-early-hints](https://developers.cloudflare.com/workers/examples/103-early-hints/)
* [workers/examples/ab-testing](https://developers.cloudflare.com/workers/examples/ab-testing/)
* [workers/examples/accessing-the-cloudflare-object](https://developers.cloudflare.com/workers/examples/accessing-the-cloudflare-object/)
* [workers/examples/aggregate-requests](https://developers.cloudflare.com/workers/examples/aggregate-requests/)
* [workers/examples/alter-headers](https://developers.cloudflare.com/workers/examples/alter-headers/)
* [workers/examples/auth-with-headers](https://developers.cloudflare.com/workers/examples/auth-with-headers/)
* [workers/examples/block-on-tls](https://developers.cloudflare.com/workers/examples/block-on-tls/)
* [workers/examples/basic-auth](https://developers.cloudflare.com/workers/examples/basic-auth/)
* [workers/examples/bulk-origin-proxy](https://developers.cloudflare.com/workers/examples/bulk-origin-proxy/)
* [workers/examples/bulk-redirects](https://developers.cloudflare.com/workers/examples/bulk-redirects/)
* [workers/examples/cache-api](https://developers.cloudflare.com/workers/examples/cache-api/)
* [workers/examples/cache-post-request](https://developers.cloudflare.com/workers/examples/cache-post-request/)
* [workers/examples/cache-tags](https://developers.cloudflare.com/workers/examples/cache-tags/)
* [workers/examples/cache-using-fetch](https://developers.cloudflare.com/workers/examples/cache-using-fetch/)
* [workers/examples/cors-header-proxy](https://developers.cloudflare.com/workers/examples/cors-header-proxy/)
* [workers/examples/conditional-response](https://developers.cloudflare.com/workers/examples/conditional-response/)
* [workers/examples/cron-trigger](https://developers.cloudflare.com/workers/examples/cron-trigger/)
* [workers/examples/country-code-redirect](https://developers.cloudflare.com/workers/examples/country-code-redirect/)
* [workers/examples/data-loss-prevention](https://developers.cloudflare.com/workers/examples/data-loss-prevention/)
* [workers/examples/debugging-logs](https://developers.cloudflare.com/workers/examples/debugging-logs/)
* [workers/examples/extract-cookie-value](https://developers.cloudflare.com/workers/examples/extract-cookie-value/)
* [workers/examples/fetch-json](https://developers.cloudflare.com/workers/examples/fetch-json/)
* [workers/examples/fetch-html](https://developers.cloudflare.com/workers/examples/fetch-html/)
* [workers/examples/geolocation-app-weather](https://developers.cloudflare.com/workers/examples/geolocation-app-weather/)
* [workers/examples/geolocation-custom-styling](https://developers.cloudflare.com/workers/examples/geolocation-custom-styling/)
* [workers/examples/geolocation-hello-world](https://developers.cloudflare.com/workers/examples/geolocation-hello-world/)
* [workers/examples/hot-link-protection](https://developers.cloudflare.com/workers/examples/hot-link-protection/)
* [workers/examples/images-workers](https://developers.cloudflare.com/workers/examples/images-workers/)
* [workers/examples/logging-headers](https://developers.cloudflare.com/workers/examples/logging-headers/)
* [workers/examples/modify-request-property](https://developers.cloudflare.com/workers/examples/modify-request-property/)
* [workers/examples/modify-response](https://developers.cloudflare.com/workers/examples/modify-response/)
* [workers/examples/multiple-cron-triggers](https://developers.cloudflare.com/workers/examples/multiple-cron-triggers/)
* [workers/examples/openai-sdk-streaming](https://developers.cloudflare.com/workers/examples/openai-sdk-streaming/)
* [workers/examples/protect-against-timing-attacks](https://developers.cloudflare.com/workers/examples/protect-against-timing-attacks/)
* [workers/examples/post-json](https://developers.cloudflare.com/workers/examples/post-json/)
* [workers/examples/redirect](https://developers.cloudflare.com/workers/examples/redirect/)
* [workers/examples/respond-with-another-site](https://developers.cloudflare.com/workers/examples/respond-with-another-site/)
* [workers/examples/read-post](https://developers.cloudflare.com/workers/examples/read-post/)
* [workers/examples/return-html](https://developers.cloudflare.com/workers/examples/return-html/)
* [workers/examples/return-json](https://developers.cloudflare.com/workers/examples/return-json/)
* [workers/examples/rewrite-links](https://developers.cloudflare.com/workers/examples/rewrite-links/)
* [workers/examples/security-headers](https://developers.cloudflare.com/workers/examples/security-headers/)
* [workers/examples/signing-requests](https://developers.cloudflare.com/workers/examples/signing-requests/)
* [workers/examples/turnstile-html-rewriter](https://developers.cloudflare.com/workers/examples/turnstile-html-rewriter/)
* [workers/tutorials/build-a-slackbot](https://developers.cloudflare.com/workers/tutorials/build-a-slackbot/)
* [workers/tutorials/connect-to-turso-using-workers](https://developers.cloudflare.com/workers/tutorials/connect-to-turso-using-workers/)
* [workers/tutorials/create-finetuned-chatgpt-ai-models-with-r2](https://developers.cloudflare.com/workers/tutorials/create-finetuned-chatgpt-ai-models-with-r2/)
* [workers/tutorials/deploy-an-express-app](https://developers.cloudflare.com/workers/tutorials/deploy-an-express-app/)
* [workers/tutorials/mysql](https://developers.cloudflare.com/workers/tutorials/mysql/)
* [workers/tutorials/postgres](https://developers.cloudflare.com/workers/tutorials/postgres/)
* [workers/tutorials/upload-assets-with-r2](https://developers.cloudflare.com/workers/tutorials/upload-assets-with-r2/)
* [workers/tutorials/using-prisma-postgres-with-workers](https://developers.cloudflare.com/workers/tutorials/using-prisma-postgres-with-workers/)
* [workflows/examples/backup-d1](https://developers.cloudflare.com/workflows/examples/backup-d1/)
* [workflows/examples/send-invoices](https://developers.cloudflare.com/workflows/examples/send-invoices/)
* [queues/tutorials/handle-rate-limits](https://developers.cloudflare.com/queues/tutorials/handle-rate-limits/)
* [queues/tutorials/web-crawler-with-browser-rendering](https://developers.cloudflare.com/queues/tutorials/web-crawler-with-browser-rendering/)
* [workers-ai/guides/tutorials/image-generation-playground/image-generator-flux-newmodels](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-flux-newmodels/)
* [workers-ai/guides/tutorials/image-generation-playground/image-generator-flux](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-flux/)
* [workers-ai/guides/tutorials/image-generation-playground/image-generator-store-and-catalog](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-store-and-catalog/)
* [workers-ai/guides/tutorials/image-generation-playground](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/)

### TypeScript

Variants:

* `ts`

Used on `1` pages.

Pages tagged with TypeScript

* [workflows/examples/wait-for-event](https://developers.cloudflare.com/workflows/examples/wait-for-event/)

### URL rewrite

Variants:

* `rewrite`

Used on `10` pages.

Pages tagged with URL rewrite

* [rules/snippets/examples/ab-testing-same-url](https://developers.cloudflare.com/rules/snippets/examples/ab-testing-same-url/)
* [rules/snippets/examples/route-and-rewrite](https://developers.cloudflare.com/rules/snippets/examples/route-and-rewrite/)
* [rules/transform/examples/normalize-encoded-slash](https://developers.cloudflare.com/rules/transform/examples/normalize-encoded-slash/)
* [rules/transform/examples/rewrite-archive-urls-new-format](https://developers.cloudflare.com/rules/transform/examples/rewrite-archive-urls-new-format/)
* [rules/transform/examples/rewrite-moved-section](https://developers.cloudflare.com/rules/transform/examples/rewrite-moved-section/)
* [rules/transform/examples/rewrite-path-object-storage](https://developers.cloudflare.com/rules/transform/examples/rewrite-path-object-storage/)
* [rules/transform/examples/rewrite-path-archived-posts](https://developers.cloudflare.com/rules/transform/examples/rewrite-path-archived-posts/)
* [rules/transform/examples/rewrite-several-url-different-url](https://developers.cloudflare.com/rules/transform/examples/rewrite-several-url-different-url/)
* [rules/transform/examples/rewrite-welcome-for-countries](https://developers.cloudflare.com/rules/transform/examples/rewrite-welcome-for-countries/)
* [rules/transform/examples/rewrite-url-string-visitors](https://developers.cloudflare.com/rules/transform/examples/rewrite-url-string-visitors/)

### Vue.js

Variants:

* `vue`
* `vuejs`

Used on `1` pages.

Pages tagged with Vue.js

* [pages/tutorials/build-a-blog-using-nuxt-and-sanity](https://developers.cloudflare.com/pages/tutorials/build-a-blog-using-nuxt-and-sanity/)

### Web Crypto

Variants:

* `webcrypto`

Used on `3` pages.

Pages tagged with Web Crypto

* [workers/examples/auth-with-headers](https://developers.cloudflare.com/workers/examples/auth-with-headers/)
* [workers/examples/protect-against-timing-attacks](https://developers.cloudflare.com/workers/examples/protect-against-timing-attacks/)
* [workers/examples/signing-requests](https://developers.cloudflare.com/workers/examples/signing-requests/)

### WebSockets

Variants:

* `websocket`

Used on `3` pages.

Pages tagged with WebSockets

* [durable-objects/examples/websocket-hibernation-server](https://developers.cloudflare.com/durable-objects/examples/websocket-hibernation-server/)
* [durable-objects/examples/websocket-server](https://developers.cloudflare.com/durable-objects/examples/websocket-server/)
* [workers/examples/websockets](https://developers.cloudflare.com/workers/examples/websockets/)

### WordPress

Used on `1` pages.

Pages tagged with WordPress

* [pages/how-to/deploy-a-wordpress-site](https://developers.cloudflare.com/pages/how-to/deploy-a-wordpress-site/)

### YAML

Used on `2` pages.

Pages tagged with YAML

* [pulumi/tutorial/add-site](https://developers.cloudflare.com/pulumi/tutorial/add-site/)
* [pulumi/tutorial/hello-world](https://developers.cloudflare.com/pulumi/tutorial/hello-world/)

### Full stack

Variants:

* `full-stack`

Used on `9` pages.

Pages tagged with Full stack

* [workers/framework-guides/web-apps/astro](https://developers.cloudflare.com/workers/framework-guides/web-apps/astro/)
* [workers/framework-guides/web-apps/nextjs](https://developers.cloudflare.com/workers/framework-guides/web-apps/nextjs/)
* [workers/framework-guides/web-apps/react-router](https://developers.cloudflare.com/workers/framework-guides/web-apps/react-router/)
* [workers/framework-guides/web-apps/redwoodsdk](https://developers.cloudflare.com/workers/framework-guides/web-apps/redwoodsdk/)
* [workers/framework-guides/web-apps/tanstack-start](https://developers.cloudflare.com/workers/framework-guides/web-apps/tanstack-start/)
* [workers/framework-guides/web-apps/more-web-frameworks/angular](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/angular/)
* [workers/framework-guides/web-apps/more-web-frameworks/nuxt](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/nuxt/)
* [workers/framework-guides/web-apps/more-web-frameworks/qwik](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/qwik/)
* [workers/framework-guides/web-apps/more-web-frameworks/solid](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/solid/)

### SPA

Used on `3` pages.

Pages tagged with SPA

* [workers/framework-guides/web-apps/react](https://developers.cloudflare.com/workers/framework-guides/web-apps/react/)
* [workers/framework-guides/web-apps/svelte](https://developers.cloudflare.com/workers/framework-guides/web-apps/svelte/)
* [workers/framework-guides/web-apps/vue](https://developers.cloudflare.com/workers/framework-guides/web-apps/vue/)

### SSG

Used on `3` pages.

Pages tagged with SSG

* [workers/framework-guides/web-apps/astro](https://developers.cloudflare.com/workers/framework-guides/web-apps/astro/)
* [workers/framework-guides/web-apps/more-web-frameworks/docusaurus](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/docusaurus/)
* [workers/framework-guides/web-apps/more-web-frameworks/gatsby](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/gatsby/)
